<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2016 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/


// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CBreadCrumb extends CPlugin{
	
	var $tplvars; 
	var $htmldata = "";

	function __constructor() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"main"					=> "main.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

//		$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule("comments");


	} 

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Remove() {
		$this->title = "";
		$this->bpath = "";

		$this->removed = true;


		global $_TSM;

		$_TSM["BREADCRUMB"] = "";

	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function HTML($data) {
		$this->htmldata = $data;
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Add($title , $path = array(), $protected = false , $module = null) {

		$this->title = $title;
		$this->bpath = $path;

		$this->_protected = $protected;
		$this->_module = $module;

		if ($this->title["raw"]["text_menu"] != "") {
			$this->plugins["skineditor"]->setBodyAttr("data-menu-over-title" , $this->title["raw"]["text_menu"] ? "true" : "false" , true);
		}

	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render() {

		$this->__init();

		if ($this->htmldata != "") {
			return $this->htmldata;
		}
		

		//if no title was set then return a clean path

		if (!is_array($this->title) && $this->title) {
			$this->title = array(
				"title"		=> $this->title,
				"subtitle"	=> "",
				"show"		=> "1",
			);
		}
		

		if (
			(is_array($this->title) && !($this->title["title"] || $this->title["subtitle"])) || 
			(!is_array($this->title) && !$this->title)	
		){
			return $this->private->templates["main"]->blockReplace("Empty");
		}


		if (is_array($this->title) && !$this->title["show"]) {
			return "";
		}
		

//		if ((is_array($this->title) && !$this->title["title"]) || (!is_array($this->title) && !$this->title)) {
//		}

		if ($this->removed) {
			return "";
		}
		

		if (is_Array($this->bpath)) {

			if ($this->_protected) {

				//array_unshift($this->bpath , array("link" => "/account/" , title=)

				$tmp = $this->plugins["users"]->AccountLink();
				$path[$tmp["link"]] = $tmp["title"];

				foreach ($this->bpath as $key => $val) {
					$path[$key] = $val;
				}


				$this->bpath = $path;

				$path = "";
			}
			
			foreach ($this->bpath as $key => $val) {
				$path .= $this->private->templates["main"]->blockReplace(
					"PathElement",
					$links[] = array(
						"link"	=> $key, 
						"title"	=> $val
					)
				);

			}


			$this->plugins["seo"]->BreadCrumb($links);

			if ($this->_module["home"]) {
				$path = "";
			}
			

			if ($this->vars->data["set_pt_breadcrumb"]) {
				$path_html = $this->private->templates["main"]->blockReplace(
					"Path",
					array(
						"data"	=> $path, 
					)
				);			
			}					
		}

		$set = array(
			"text_title_align"			=> "set_title_align",
			"text_subtitle_align"		=> "set_subtitle_align",
			"text_title_valign"			=> "set_title_valign",
			"text_subtitle_valign"		=> "set_subtitle_valign",

			"text_title_size"			=> "set_title_size",
			"text_title_size_lg"		=> "set_title_size_lg",
			"text_title_size_md"		=> "set_title_size_md",
			"text_title_size_sm"		=> "set_title_size_sm",
			"text_title_size_xs"		=> "set_title_size_xs",

			"text_subtitle_size"		=> "set_subtitle_size",
			"text_subtitle_size_lg"		=> "set_subtitle_size_lg",
			"text_subtitle_size_md"		=> "set_subtitle_size_md",
			"text_subtitle_size_sm"		=> "set_subtitle_size_sm",
			"text_subtitle_size_xs"		=> "set_subtitle_size_xs",

			"text_pt_css"				=> "set_pt_css",
			"text_pt_css_title"			=> "set_pt_css_title",
			"text_pt_css_subtitle"		=> "set_pt_css_subtitle",

			"text_pt_path_align"		=> "set_pt_path_align",

		);
		//prepare settings

		foreach ($set as $key => $val) {
			if (!$this->title["raw"][$key]) {
				$set[$key] = $this->vars->data[$val];
			} else {
				$set[$key] = $this->title["raw"][$key];
			}
		}
		
	
		
		return $this->private->templates["main"]->blockReplace(
			"Main" , 
			array(
				"title"		=> is_array($this->title) ? $this->title["title"] : "",
				"subtitle"	=> 
					is_array($this->title) && $this->title["subtitle"]  && $this->private->templates["main"]->BlockExists("Subtitle") ? 
					$this->private->templates["main"]->BlockReplace(
						"Subtitle",
						array(
							"header"	=> $this->title["subtitle"]
						)
					)  : "",

				"path"	=> $path_html,

				"module_id"	=> $this->_module["mod_id"] ? $this->_module["mod_id"]  : $this->_module["module_code"] ,
			),
			$set
		);
	} 

	
	function onGlobalHooksExecute($module) {
		global $_TSM;

		$_TSM["BREADCRUMB"] = "";
	}

}

?>